﻿/*
VERSION:		1.4a
1.4a	Manually detect onRelease + onReleaseOutside		... But this should not be necessary.  Also, onRollOver no longer works
1.3		fixed triggerChildren() and triggerHitChildren()
			added "isHit" param to triggerHitChildren() to allow excluding collision
1.2		use sendEvent()

NOTE:
	Do not use this if your pseudo-component is going to contain custom components.
	All of their mouse functionality will be disabled if you do.
	
	Default flash components such as "Button" and "List" are not affected for some reason.
	Only your custom components are adversely affected by this.
	
USAGE:
	#include "functions/addMouseEvents.as"
	addMouseEvents( this );
*/
if( !addListener && !addEventListener )		AsBroadcaster.initialize( this );
#include "eventSystem3.as"
#include "sendEvent.as"
#include "updateOnce.as"
addMouseEvents = function( _this )
{
	if( !react )		var react = make_react( _this );
	if( !_this.onUnload ){
		_this.onUnload = function(){
			_this.sendEvent("unload");
		}
	}
	
	// _________________________________________________
	// MOUSE EVENTS
	var triggerChildren = function( functName )
	{
		for(var nam in _this)
		{
			if( typeof(_this[nam]) == "movieclip"  &&  _this[nam] != _this )
			{
				_this[nam][functName]();		// call trigger
			}
		}// for:  all children
	}// triggerChildren()
	
	
	
	var triggerHitChildren = function( functName, isHit )
	{
		if(isHit===undefined)		var isHit = true;
		for(var nam in _this)
		{
			if( typeof(_this[nam]) == "movieclip"  &&  _this[nam] != _this )
			{
				if( _this[nam].hitTest(_root._xmouse, _root._ymouse, false) === isHit ){
					var path = _this+"."+nam+"."+functName;
					_this[nam][functName]();		// call trigger
				}
			}
		}// for:  all children
	}// triggerHitChildren()
	
	
	
	_this.onDragOut = function(){
		sendEvent("onDragOut",null,_this);
		//triggerChildren("onDragOut");
		triggerHitChildren("onDragOut", false);
	}// onDragOut()
	_this.onDragOver = function(){
		sendEvent("onDragOver",null,_this);
		triggerHitChildren("onDragOver");
		//triggerChildren("onDragOver");
	}// onDragOver()
	_this.onMouseMove = function(){
		sendEvent("onMouseMove",null,_this);
	}// onMouseMove()
	_this.onPress = function(){
		sendEvent("onPress",null,_this);
		triggerHitChildren("onPress");
	}// onPress()
	_this.onRelease = function(){
		sendEvent("onRelease",null,_this);
		triggerHitChildren("onRelease");
	}// onRelease()
	_this.onRelease = updateOnce( _this.onRelease );
	_this.onReleaseOutside = function(){
		sendEvent("onReleaseOutside",null,_this);
		triggerHitChildren("onReleaseOutside", false);
		//triggerChildren("onReleaseOutside");
	}// onReleaseOutside()
	_this.onRelease = updateOnce( _this.onReleaseOutside );
	_this.onRollOut = function(){
		sendEvent("onRollOut",null,_this);
		triggerHitChildren("onRollOut", false);
		//triggerChildren("onRollOut");
	}// onRollOut()
	_this.onRollOver = function(){
		sendEvent("onRollOver",null,_this);
		triggerHitChildren("onRollOver");
		//triggerChildren("onRollOver");
	}// onRollOver()
	
	// manually detect onRelease
	react.to("onMouseUp").from(Mouse).then = function(){
		if(_this.hitTest(_root._xmouse, _root._ymouse, false) ){
			// cursor within
			mdm.Exception.DebugWindow.trace("inside");
			_this.onRelease();
		}else{
			// cursor outside
			mdm.Exception.DebugWindow.trace("outside");
			_this.onReleaseOutside();
		}
	}
	//
}// addMouseEvents()